/*
 * Decompiled with CFR 0.152.
 */
package jace.hardware;

import jace.hardware.FloppyDisk;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.LockSupport;

public class DiskIIDrive {
    FloppyDisk disk;
    public static long WRITE_UPDATE_DELAY = 1000L;
    boolean diskUpdatePending = false;
    long lastWriteTime;
    Thread writerThread;
    private final byte[][] driveHeadStepDelta = new byte[][]{{0, 0, 1, 1, 0, 0, 1, 1, -1, -1, 0, 0, -1, -1, 0, 0}, {0, -1, 0, -1, 1, 0, 1, 0, 0, -1, 0, -1, 1, 0, 1, 0}, {0, 0, -1, -1, 0, 0, -1, -1, 1, 1, 0, 0, 1, 1, 0, 0}, {0, 1, 0, 1, -1, 0, -1, 0, 0, 1, 0, 1, -1, 0, -1, 0}};
    private int halfTrack;
    private int trackStartOffset;
    private int nibbleOffset;
    private boolean writeMode;
    private boolean driveOn;
    private int magnets;
    byte latch;
    private int spinCount;
    Set<Integer> dirtyTracks;

    public void reset() {
        this.driveOn = false;
        this.magnets = 0;
        this.dirtyTracks = new HashSet<Integer>();
        this.diskUpdatePending = false;
    }

    void step(int register) {
        byte delta;
        int magnet = register >> 1 & 3;
        this.magnets &= ~(1 << magnet);
        this.magnets |= (register & 1) << magnet;
        if (this.driveOn && (delta = this.driveHeadStepDelta[this.halfTrack & 3][this.magnets]) != 0) {
            int newHalfTrack = this.halfTrack + delta;
            if (newHalfTrack < 0) {
                newHalfTrack = 0;
            } else if (newHalfTrack > 70) {
                newHalfTrack = 70;
            }
            if (newHalfTrack != this.halfTrack) {
                this.halfTrack = newHalfTrack;
                this.trackStartOffset = (this.halfTrack >> 1) * 6656;
                if (this.trackStartOffset >= 232960) {
                    this.trackStartOffset = 226304;
                }
                this.nibbleOffset = 0;
            }
        }
    }

    void setOn(boolean b) {
        this.driveOn = b;
    }

    boolean isOn() {
        return this.driveOn;
    }

    byte readLatch() {
        byte result = 127;
        if (!this.writeMode) {
            this.spinCount = this.spinCount + 1 & 0xF;
            if (this.spinCount > 0) {
                result = this.disk != null ? this.disk.nibbles[this.trackStartOffset + this.nibbleOffset++] : (byte)0;
            }
            if (this.nibbleOffset >= 6656) {
                this.nibbleOffset = 0;
            }
        } else {
            this.spinCount = this.spinCount + 1 & 0xF;
            if (this.spinCount > 0) {
                result = -128;
            }
        }
        return result;
    }

    void write() {
        if (this.writeMode) {
            while (this.diskUpdatePending) {
                LockSupport.parkNanos(1000L);
            }
            if (this.disk != null) {
                this.dirtyTracks.add(this.trackStartOffset / 6656);
                this.disk.nibbles[this.trackStartOffset + this.nibbleOffset++] = this.latch;
                this.triggerDiskUpdate();
            }
            if (this.nibbleOffset >= 6656) {
                this.nibbleOffset = 0;
            }
        }
    }

    void setLatchValue(byte value) {
        this.latch = this.writeMode ? value : (byte)-1;
    }

    void setReadMode() {
        this.writeMode = false;
    }

    void setWriteMode() {
        this.writeMode = true;
    }

    private void updateDisk() {
        this.diskUpdatePending = true;
        for (Integer track : this.dirtyTracks) {
            if (this.disk == null) continue;
            this.disk.updateTrack(track);
        }
        this.dirtyTracks.clear();
        this.diskUpdatePending = false;
    }

    private void triggerDiskUpdate() {
        this.lastWriteTime = System.currentTimeMillis();
        if (this.writerThread == null || !this.writerThread.isAlive()) {
            this.writerThread = new Thread(new Runnable(){

                public void run() {
                    long diff = 0L;
                    while ((diff = System.currentTimeMillis() - DiskIIDrive.this.lastWriteTime) < WRITE_UPDATE_DELAY) {
                        LockSupport.parkNanos(diff * 1000L);
                    }
                    DiskIIDrive.this.updateDisk();
                }
            });
            this.writerThread.start();
        }
    }

    void insertDisk(File diskPath) throws IOException {
        this.disk = new FloppyDisk(diskPath);
        this.dirtyTracks = new HashSet<Integer>();
    }

    void ejectDisk() {
        this.disk = null;
        this.dirtyTracks = new HashSet<Integer>();
    }
}

